; $Id$
;
; Assembly language to playback IR remote control signals. Parts of
; this program are taken from c't 1991, Heft 8 (pp 174 - 178).
;
; It uses the same timer as for recording, playing back the signal
; array to the IR LED.

; Chris Dodge - April 94
;
				.MODEL	small
				.CODE
				PUBLIC  @PlayIR$qpzci   ; CPP mangled name for PlayIR !
@PlayIR$qpzci	PROC		NEAR
				push		bp
				mov			bp, sp
				push		si
				push 		ds
				mov     si, [bp+4]						; Get pointer to array
				mov			cx, [bp+6]						; Get size of array

; Identify printer port
				push		es										; Save ES and SI
				push		si

				mov			ax, 40h
				mov			es, ax
				mov			si, 0                 ; Printer port -> SI (lpt1 = 0)
				shl			si, 1
				mov			dx, es:[si+8]					; Port address -> DX
				inc			dx										; Port status reg is 1 byte higher

				pop			si										; Pull ES and SI back
				pop			es
				mov			bx, 0                 ; Set counter to 0

				call		play_sequence

exit:		sti														; Allow interrupts again
				mov     ax, bx

				pop			ds
				pop			si
				pop			bp
				ret

@PlayIR$qpzci	ENDP

play_sequence PROC NEAR

				cli                           ; Disable interrupts

L2:     ; Wait loop until BUSY is low, ie. can then take next input
				in			al, dx                ; Read value into AL
				mov			ah, al                ; Make backup in AH
				and			al, 10000000b					; Mask the BUSY bit...
				cmp			al, 10000000b					; ... and check if set
				je			L2

				mov			al, [si][bx]					; Get next value in signal array
				and     al, 00000010b         ; Signal bit is bit 2
				cmp			al, 00000000b					; Is it a "1" or "0"
				je			P2										;

P1:			mov			al, 00000010b					; Output 0 at printer port
				jmp			P3                    ; .. bit 2 flashes the LED

P2:			mov			al, 00000011b					; Output 1 at printer port
				jmp			P3                    ; .. bit 2 flashes the LED

P3:			mov     ah, 0                 ; Function 0 = print char
				dec			dx                    ; Set dx to printer port
				out     dx, al                ; Output dx to port
				inc     dx                    ; Set dx back to status reg
				inc			bx										; Incriment array pointer

S2:			; Loop until trigger is set to 0 again (BUSY low)
				in			al, dx
				mov			ah, al
				and			al, 10000000b
				cmp			al, 10000000b
				jne			S2

P4:			; Main loop - count until the signal array is full
				cmp			bx, cx
				jle			L2

				; End of play loop, set the data line to 0
				mov			ah, 0                  ; Function 0 = print char
				mov			al, 0                  ; Set char to 0
				dec			dx
				out     dx, al                 ; Print 0

				ret
play_sequence ENDP
				END